/*************************************************************************

   This program is shareware. If you use it and find it useful please
   send ($25 is suggested) or whatever you think it is worth to :

			 Raymond P. Wilson
			 38 Paremata St.
			 Atawhai
			 Nelson
			 New Zealand

   If you wish to use this program or parts of this program in a
commercial the authors permission is required.

Copyright Raymond P. Wilson 1989

**************************************************************************/

/* arithmetic coding routines */

/* Most of the functions here have been converted to macro definitions
   to speed them up and have been customised for a binary alphabet */

#define codevaluebits 16
typedef long codevalue ;

#define topvalue (((long)1<<codevaluebits)-1)

#define firstqtr (topvalue/4+1)
#define half     (2*firstqtr)
#define thirdqtr (3*firstqtr)

codevalue	S_value=0 ;
int		S_buffer=0;

/* Macro definition for call to get number in range when decoding files */
#define	arithmetic_decode_target(totl)	\
       (  (((long)(S_value-S_low)+1)*(totl)-1)/ ((long)(S_high -S_low)+1)  )

/*==================================*/

#define addnextinputbit(v) 	\
  { S_bitstogo--;		\
    if (S_bitstogo<0) 		\
      { S_buffer = getc(stdin) ;\
        S_bitstogo = 7 ; 	\
      } 			\
    v += (S_buffer & 1) ; 	\
    S_buffer >>= 1 ; 		\
  } 

/*==================================*/

#define arithmetic_decode_zero(hbnd, totl) 				\
{									\
   S_high = S_low  +  (((long)(S_high-S_low)+1) * hbnd)/totl - 1 ;	\
   									\
   for (;;)								\
     { if (S_high<H) 							\
         { /* nothing */						\
         }								\
       else								\
       if (S_low>=H) 							\
         { S_value -= H ;						\
           S_low -= H ;							\
           S_high -= H ;						\
         }								\
       else								\
       if (S_low>=firstqtr && S_high<thirdqtr)				\
         { S_value -= firstqtr ;					\
           S_low -= firstqtr ;						\
           S_high -= firstqtr ;						\
         }								\
       else break ;							\
       S_low <<= 1;							\
       S_high = (S_high << 1) | 1;					\
       S_value <<= 1 ;							\
       addnextinputbit(S_value) ;					\
    }									\
 }

/*======================================================================*/

#define arithmetic_decode_one(lbnd, totl)  				\
{ 									\
   S_low  +=  (((long)(S_high-S_low)+1)*lbnd)/totl ; 			\
   for (;;) 								\
   { if (S_high<H)  							\
       { /* nothing */ 							\
       } 								\
     else 								\
       if (S_low>=H)  							\
         { S_value -= H ; 						\
           S_low -= H ; 						\
           S_high -= H ; 						\
         } 								\
       else 								\
       if (S_low>=firstqtr && S_high<thirdqtr) 				\
         { S_value -= firstqtr ; 					\
           S_low -= firstqtr ; 						\
           S_high -= firstqtr ; 					\
         } 								\
       else break ; 							\
       S_low <<= 1; 							\
       S_high = (S_high << 1) | 1; 					\
       S_value <<= 1; 							\
       addnextinputbit(S_value) ; 					\
    } 									\
 }

/*==================================*/

#define startdecoding()			\
  { register int i ;			\
    S_value = 0 ;			\
    for (i=1; i<=codevaluebits; i++)	\
      { S_value += S_value ;		\
        addnextinputbit(S_value) ;	\
      }					\
    S_low = 0 ;				\
    S_high = topvalue ;			\
  }					\

#define startinputingbits()		\
S_bitstogo = 0 ;
